;C prototype: void DrawBlockMove (short x, short y, void *sprite, void *dest);
;
;void DrawBlockMove (register short x asm("%d0"),
;		     register short y asm("%d1"),
;		     register void *sprite asm("%a1"),
;		     register void *dest asm("%a0"));

	xdef	DrawBlockMove

DrawBlockMove:
    move.w   d1,d2
    lsl.w    #4,d1
    sub.w    d2,d1

    move.w   d0,d2
    lsr.w    #4,d2

    add.w    d2,d1
    add.w    d1,d1
    adda.w   d1,a0

    moveq.l  #5,d2

    and.w    #$0F,d0
    cmpi.w   #7,d0
    bls.s    Pre_Boucle16_LSR

    moveq    #16,d1
    sub.w    d0,d1

    lsr.w    #1,d2
    bcs.s    _loop_Sprite16_MASK

    lea.l    -30(a0),a0
    bra.s    Milieu_Boucle16

_loop_Sprite16_MASK:
; light mask line 1
    move.l   #$FFFF0000,d0
    rol.l    d1,d0
    and.l    d0,(a0)
; dark mask line 1
    and.l    d0,6000(a0)
; light sprite line 1
    moveq    #0,d0
    move.w   (a1)+,d0
    lsl.l    d1,d0
    or.l     d0,(a0)
;dark sprite line 1
    moveq    #0,d0
    move.w   (a1)+,d0
    lsl.l    d1,d0
    or.l     d0,6000(a0)

Milieu_Boucle16:
; light mask line 2
    move.l   #$FFFF0000,d0
    rol.l    d1,d0
    and.l    d0,30(a0)
; dark mask line 2
    and.l    d0,6000+30(a0)
; light sprite line 2
    moveq    #0,d0
    move.w   (a1)+,d0
    lsl.l    d1,d0
    or.l     d0,30(a0)
; dark sprite line 2
    moveq    #0,d0
    move.w   (a1)+,d0
    lsl.l    d1,d0
    or.l     d0,6000+30(a0)

    lea.l    60(a0),a0

    dbf      d2,_loop_Sprite16_MASK

    ;Ligne noir
    moveq    #0,d0
    move.w   #-1,d0
    lsl.l    d1,d0
    or.l     d0,(a0)
    or.l     d0,6000(a0)
    rts

Pre_Boucle16_LSR:
    lsr.w    #1,d2
    bcs.s    Boucle16_LSR

    lea.l    -30(a0),a0
    bra.s    Milieu_Boucle16_LSR

Boucle16_LSR:
; light mask, line 1
    move.l   #$FFFF0000,d1
    swap     d1
    ror.l    d0,d1
    and.l    d1,(a0)
; dark mask, line 1
    and.l    d1,6000(a0)
; light sprite, line 1
    moveq.l  #0,d1
    move.w   (a1)+,d1
    swap.w   d1
    lsr.l    d0,d1
    or.l     d1,(a0)
; dark sprite, line 1
    moveq    #0,d1
    move.w   (a1)+,d1
    swap.w   d1
    lsr.l    d0,d1
    or.l     d1,6000(a0)

Milieu_Boucle16_LSR:
; light mask, line 2
    move.l   #$FFFF0000,d1
    swap     d1
    ror.l    d0,d1
    and.l    d1,30(a0)
; dark mask, line 2
    and.l    d1,6000+30(a0)
; light sprite, line 2
    moveq    #0,d1
    move.w   (a1)+,d1
    swap.w   d1
    lsr.l    d0,d1
    or.l     d1,30(a0)
; dark sprite, line 2
    moveq    #0,d1
    move.w   (a1)+,d1
    swap.w   d1
    lsr.l    d0,d1
    or.l     d1,6000+30(a0)

    lea.l    60(a0),a0

    dbf      d2,Boucle16_LSR
  
    ;Ligne noir
    moveq    #0,d1
    move.w   #-1,d1
    swap.w   d1
    lsr.l    d0,d1
    or.l     d1,(a0)
    or.l     d1,6000(a0)
    rts